/*! \file 
**********************************************************************************	
* Title:						Discretix SST Version implementation file						 					
*																			
* Filename:					    sst_api_version.h															
*																			
* Project, Target, subsystem:	SST Host IF, APIs	
*                               
* Created:						01.07.2007																	
*                               
* Modified:																					
*                               
* \Author						Ira Boguslavsky																
*																			
* \Remarks						
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "SEPDriver.h"
#include "error.h"
#include "sst_errors.h"
#include "sst_sep_errors.h"
#include "sst_version.h"
#include "sst_host_util.h"
#include "sst_host_def.h"
#include "sst_host_op_code.h"

/******************/
/* SST_VersionGet */
/******************/
DxError_t SST_VersionGet(SSTVersion_t *version_ptr)
{
    DxUint32_t              paramInBuffer_ptr [DX_2_WORDS_PARAMS];
    DxUint32_t              paramOutBuffer_ptr[DX_2_WORDS_PARAMS + sizeof(SSTVersion_t)];
    DxError_t               errorRC;

    if(DX_IS_NULL_PARAM(version_ptr))
        return SST_RC_ERROR_NULL_POINTER;

	/************************************************************************/
	/*  Lock access to SEP                                                  */
	/************************************************************************/
   errorRC = SEPDriver_Lock();
   if(DX_MNG_SEP_IS_DISABLE_ERR == errorRC)
   {
       errorRC = SST_RC_ERROR_SEP_DISABLED; 
       goto exit_function;
   }
   else if (DX_OK != errorRC)
   {
       errorRC = SST_RC_ERROR_SEP; 
       goto exit_function;
   }
	/************************************************************************/
    /* Prepare input buffer                                                 */
    /************************************************************************/
    /* Operation Code */
    paramInBuffer_ptr[0] = SST_SEP_OP_CODE_VERSION_GET;

    /************************************************************************/
    /* Send an input buffer to SeP and wait for output parameters          */
    /************************************************************************/
    errorRC = SST_SendOneMsgGetResponse(paramInBuffer_ptr,
                                        /* Input buffer length */
                                        sizeof(DxUint32_t),
                                        paramOutBuffer_ptr,
                                        /* Output buffer length */
										DX_ALIGN_TO_WORD(DX_2_WORDS_PARAMS + SST_VERSION_MAX_PARAM_LEN_IN_BYTES));
    if (DX_OK != errorRC)
        goto exit_version_get;

    /************************************************************************/
    /* Analyze return buffer                                                */
    /************************************************************************/
    /* Op code */
    if (paramOutBuffer_ptr[0] != SST_SEP_OP_CODE_VERSION_GET)
    {
        errorRC = SST_RC_ERROR_SEP;
        goto exit_version_get;
    }

    /* RC */    
	errorRC = paramOutBuffer_ptr[1];
	SST_HOST_RETURN_CODE_CHECK(errorRC,exit_version_get);

    /* Fill out output parameters */
    DX_VOS_FastMemCpy(version_ptr , paramOutBuffer_ptr + DX_2_WORDS_PARAMS, sizeof(SSTVersion_t));

exit_version_get: 
	/************************************************************************/
	/* UnLock access to  SEP                                                  */
	/************************************************************************/
	SEPDriver_Unlock();

exit_function:
    
    return errorRC;
}
